package com.example.sefinsa_app.ui.pagos.pagar;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import androidx.navigation.Navigation;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.models.Pago;
import com.example.sefinsa_app.models.PagosHechos;
import com.example.sefinsa_app.models.Prestamo;
import com.example.sefinsa_app.utilities.BluetoothPrint;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.NumeroLetras;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.textfield.TextInputLayout;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;



public class PagosPagarFragment extends Fragment {

    private PagosPagarViewModel mViewModel;

    private TextInputLayout tlFechaPago, tlFolio, tlPagoRecibido, tlConcepto;
    public String pagoJsonString, prestamoJsonString, pagoMulta = "0.0";
    public Pago pago;
    public Prestamo prestamo;

    private VolleyS vs;
    private RequestQueue requestQueue;

    private CheckBox cbMulta;

    private SharedPreferences sesion;

    private Button btnRegistrarPago;

    private final int CODIGO_PERMISOS_BLUETOOTH = 666;


    public static PagosPagarFragment newInstance() {
        return new PagosPagarFragment();
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_pagos_pagar, container, false);
    }


    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        CurrentFragment.fragment = "PagosPagarFragment";


        sesion = getActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);
        Bundle args = getArguments();
        pagoJsonString = args.getString("pago");
        pago = Utils.getGsonParser().fromJson(pagoJsonString, Pago.class);
        prestamoJsonString = args.getString("prestamo");
        prestamo = Utils.getGsonParser().fromJson(prestamoJsonString, Prestamo.class);

        tlFechaPago = view.findViewById(R.id.tlFechaPago);
        tlFolio = view.findViewById(R.id.tlFolio);
        tlPagoRecibido = view.findViewById(R.id.tlPagoRecibido);
        tlConcepto = view.findViewById(R.id.tlConcepto);
        btnRegistrarPago = view.findViewById(R.id.btnRegistrarPago);


        cbMulta = view.findViewById(R.id.cbMulta);



        cbMulta.setText("Aplicar multa de $"+pago.getMonto_multa());
        tlPagoRecibido.getEditText().setText(pago.getCantidad_esperada_pago());

        tlFechaPago.getEditText().setText(pago.getFecha_pago());

        cbMulta.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                if(b){
                    pagoMulta = pago.getMonto_multa();
                }
                else{
                    pagoMulta = "0.0";
                }
            }
        });

        tlFechaPago.getEditText().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                MaterialDatePicker.Builder materialDateBuilder = MaterialDatePicker.Builder.datePicker();
                materialDateBuilder.setTitleText("Fecha de pago");
                MaterialDatePicker materialDatePicker = materialDateBuilder.build();

                materialDatePicker.show(getFragmentManager(), "MATERIAL_DATE_PICKER");

                materialDatePicker.addOnPositiveButtonClickListener(
                        new MaterialPickerOnPositiveButtonClickListener() {

                            @SuppressLint("SetTextI18n")
                            @Override
                            public void onPositiveButtonClick(Object selection) {

                                TimeZone timeZoneUTC = TimeZone.getDefault();
                                int offsetFromUTC = timeZoneUTC.getOffset(new Date().getTime()) * -1;
                                SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                                Date date = new Date((Long) selection + offsetFromUTC);

                                tlFechaPago.getEditText().setText(simpleFormat.format(date));
                            }
                        });
            }
        });



        btnRegistrarPago.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {


                int permisoBT1 = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.BLUETOOTH_CONNECT);
                int permisoBT2 = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.BLUETOOTH);


                    if(Validator.fieldValidation(tlFechaPago, "Ingrese una fecha")
                            && Validator.fieldValidation(tlFolio, "Ingrese un folio")
                            && Validator.fieldValidation(tlPagoRecibido, "Ingrese un pago")){

                        String pago_recibido = tlPagoRecibido.getEditText().getText().toString();
                        String concepto = tlConcepto.getEditText().getText().toString();
                        String fecha = tlFechaPago.getEditText().getText().toString();
                        String folio = tlFolio.getEditText().getText().toString();

                        NumeroLetras numeroLetras = new NumeroLetras();

                        String recibido_con_letra = numeroLetras.Convertir(pago_recibido,
                                "", "", "",
                                "","", true);

                        pagar(pago.getId(), pago.getPrestamo_id(), pago_recibido, pagoMulta, concepto, fecha, folio, pago.getTipo_pago());

                        BluetoothPrint printBT = new BluetoothPrint(getActivity(), getActivity().getResources());
                        BluetoothPrint.printer_id = sesion.getString("impresora","SP-T12 Printer");

                        try {
                            printBT.findBT();
                            printBT.openBT();
                            printBT.printPhoto(R.drawable.credigrup_ticket_3);
                            printBT.printText(pago, tlFolio.getEditText().getText().toString(),
                                    tlPagoRecibido.getEditText().getText().toString(),
                                    pagoMulta,
                                    tlConcepto.getEditText().getText().toString(),
                                    tlFechaPago.getEditText().getText().toString(),
                                    recibido_con_letra
                            );
                            //printBT.closeBT();


                        }catch (IOException ex){ex.printStackTrace();}

                    }

            }
        });

    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case CODIGO_PERMISOS_BLUETOOTH:
                if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {

                    BluetoothPrint printBT = new BluetoothPrint(getActivity(), getActivity().getResources());

                    BluetoothPrint.printer_id = "SP-T12 Printer";

                    try {
                        printBT.findBT();
                        printBT.openBT();
                        //printBT.printText("HOLA", "DIEGO", "DUEÑEZ");
                        //printBT.closeBT();
                    }catch (IOException ex){ex.printStackTrace();}

                } else {
                    Toast.makeText(getActivity(), "Es necesario dar los permisos de bluetooth", Toast.LENGTH_SHORT).show();
                }
                break;
        }
    }

    /*
    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 666) {

        }
    }*/


    

    private void pagar(String pago_id, String prestamo_id, String pago_recibido, String pago_multa,
                       String concepto, String fecha_pago, String folio, String tipo_pago )
    {

        ProgressDialog dialog = new ProgressDialog(getActivity(),  R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "pagar");
            data.put("pago_id", pago_id);
            data.put("prestamo_id", prestamo_id);
            data.put("pago_recibido", pago_recibido);
            data.put("pago_multa", pago_multa);
            data.put("concepto", concepto);
            data.put("fecha_pago", fecha_pago);
            data.put("folio", folio);
            data.put("tipo_pago", tipo_pago);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {

                        try {

                            Date c = Calendar.getInstance().getTime();
                            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
                            String formattedDate = df.format(c);

                            PagosHechos pagoHecho = new PagosHechos(
                                    formattedDate,
                                    pago.getNombre_poblacion(),
                                    pago.getNombre_completo(),
                                    folio,
                                    concepto,
                                    String.valueOf(Utils.convertirDouble(pago_recibido)),
                                    sesion.getString("nombre_perfil", ""),
                                    pago_multa,
                                    pago.getNombre_ruta()
                            );


                            String data = response.get("message").toString();
                            dialog.cancel();
                            //Toast.makeText(getActivity(), "Pago realizado", Toast.LENGTH_SHORT).show();
                            Bundle args = new Bundle();
                            String prestamoJsonString = Utils.getGsonParser().toJson(prestamo);
                            args.putString("prestamo", prestamoJsonString);
                            Navigation.findNavController(getActivity(), R.id.nav_host_fragment_content_dashboard)
                                    .navigate(R.id.nav_pagos, args);

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                dialog.cancel();
                ErrorChecker.checker(error, getActivity());

            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        requestQueue.add(request);

    }

    public void folioConsecutivo()
    {

    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        mViewModel = new ViewModelProvider(this).get(PagosPagarViewModel.class);
        // TODO: Use the ViewModel
    }

}